/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.CommentManager;
import DE.siemens.ad.logo.model.CommentParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.panel.BlockParameterPanel;
import DE.siemens.ad.logo.model.panel.CommentPanel;
import DE.siemens.ad.logo.model.panel.ParameterPanel;
import DE.siemens.ad.logo.model.panel.ParameterPanelSourceChangedListener;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ParameterTabbedPanel
extends DataInputPanel
implements ChangeListener,
ParameterPanelSourceChangedListener {
    protected JTabbedPane fTabbedPane;
    protected Block fBlock;
    protected boolean fSimulationMode;
    protected Vector fParameterPanels;
    protected LogoDrawing fLogoDrawing;

    public ParameterTabbedPanel(Block block, Vector parameter, boolean simulationMode, LogoDrawing logoDrawing) {
        this.fBlock = block;
        this.fLogoDrawing = logoDrawing;
        this.fSimulationMode = simulationMode;
        this.setLayout(new BorderLayout());
        this.fTabbedPane = new JTabbedPane();
        this.add(this.fTabbedPane);
        this.fParameterPanels = this.insertPanels(parameter);
        this.addAsParameterPanelSourceChangedListener(this.fParameterPanels);
    }

    public ParameterTabbedPanel(Block block, CommentManager commentManager, boolean simulationMode, LogoDrawing logoDrawing) {
        this.fBlock = block;
        this.fLogoDrawing = logoDrawing;
        this.fSimulationMode = simulationMode;
        this.setLayout(new BorderLayout());
        this.fTabbedPane = new JTabbedPane();
        this.add(this.fTabbedPane);
        Vector parameter = this.getParameters(this.fBlock, this.fLogoDrawing.getCommentManager());
        this.fParameterPanels = this.insertPanels(parameter);
        this.addAsParameterPanelSourceChangedListener(this.fParameterPanels);
    }

    public boolean checkChanged() {
        for (int i = 0; i < this.fTabbedPane.getTabCount(); ++i) {
            ParameterPanel parameterPanel = (ParameterPanel)this.fTabbedPane.getComponentAt(i);
            if (!parameterPanel.checkChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean checkFieldContents() {
        boolean rw = true;
        this.fTabbedPane.getModel().removeChangeListener(this);
        for (int i = 0; i < this.fTabbedPane.getTabCount(); ++i) {
            ParameterPanel parameterPanel = (ParameterPanel)this.fTabbedPane.getComponentAt(i);
            if (parameterPanel.checkFieldContents()) continue;
            this.fTabbedPane.setSelectedComponent(parameterPanel);
            rw = false;
            break;
        }
        this.fTabbedPane.getModel().addChangeListener(this);
        return rw;
    }

    protected boolean checkPanels() {
        boolean rw = true;
        this.fTabbedPane.getModel().removeChangeListener(this);
        for (int i = 0; i < this.fTabbedPane.getTabCount(); ++i) {
            ParameterPanel parameterPanel = (ParameterPanel)this.fTabbedPane.getComponentAt(i);
            if (parameterPanel.checkFieldContents()) continue;
            this.fTabbedPane.setSelectedComponent(parameterPanel);
            rw = false;
            break;
        }
        this.fTabbedPane.getModel().addChangeListener(this);
        return rw;
    }

    public void closeEvent() {
        if (this.fSimulationMode) {
            for (int i = 0; i < this.fTabbedPane.getTabCount(); ++i) {
                ((ParameterPanel)this.fTabbedPane.getComponentAt(i)).closeEvent();
            }
        }
    }

    public Block getBlock() {
        return this.fBlock;
    }

    public String getHelpIdString() {
        try {
            return ((ParameterPanel)this.fTabbedPane.getSelectedComponent()).getHelpIdString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getBoundsID() {
        String result = super.getBoundsID();
        if (result.indexOf("Contact") > -1) {
            result = "block.Contact";
        }
        return result + this.fSimulationMode;
    }

    public String getTitle() {
        String result = this.fBlock != null ? this.fBlock.getLocalizedName(true) : "";
        return result;
    }

    protected Vector insertPanels(Vector parameter) {
        Vector allParameterPanels = new Vector();
        this.fTabbedPane.getModel().removeChangeListener(this);
        for (int j = 0; j < parameter.size(); ++j) {
            Vector currentParameterPanels = ((Parameter)parameter.elementAt(j)).getPanels(this.fSimulationMode);
            for (int i = 0; i < currentParameterPanels.size(); ++i) {
                ParameterPanel panel = (ParameterPanel)currentParameterPanels.elementAt(i);
                if (panel.getComponentCount() == 0) continue;
                if (panel instanceof BlockParameterPanel && this.fSimulationMode) {
                    ((BlockParameter)panel.getParameterReference()).addParameterUpdateListener((BlockParameterPanel)panel);
                }
                this.fTabbedPane.addTab(panel.getPanelName(), panel);
            }
            allParameterPanels.addAll(currentParameterPanels);
        }
        this.fTabbedPane.getModel().addChangeListener(this);
        return allParameterPanels;
    }

    private Vector getParameters(Block block, CommentManager commentManager) {
        CommentParameter comPar;
        Vector<Parameter> parameters = new Vector<Parameter>();
        BlockParameter blockParameter = block.getParameter();
        if (blockParameter != null) {
            parameters.addElement(blockParameter);
        }
        if ((comPar = commentManager.getCommentParameter(block)) != null) {
            parameters.addElement(comPar);
        }
        if (block.getSimulationParameter() != null) {
            parameters.addElement(block.getSimulationParameter());
        }
        return parameters;
    }

    public boolean isResizable() {
        int size = this.fTabbedPane.getComponentCount();
        for (int i = 0; i < size; ++i) {
            if (((ParameterPanel)this.fTabbedPane.getComponentAt(i)).isResizable()) continue;
            return false;
        }
        return true;
    }

    public Dimension getPreferredSize() {
        Rectangle rect = new Rectangle();
        int size = this.fTabbedPane.getComponentCount();
        for (int i = 0; i < size; ++i) {
            Dimension dim = this.fTabbedPane.getComponentAt(i).getPreferredSize();
            Util.getLarger(dim.width, dim.height, rect);
        }
        new Dimension(rect.height, rect.width);
        return super.getPreferredSize();
    }

    public void stateChanged(ChangeEvent event) {
        if (this.fTabbedPane.getSelectedComponent() instanceof CommentPanel) {
            ((CommentPanel)this.fTabbedPane.getSelectedComponent()).focusToTextArea();
        }
    }

    private void addAsParameterPanelSourceChangedListener(Vector parameterPanels) {
        Enumeration e = parameterPanels.elements();
        while (e.hasMoreElements()) {
            ((ParameterPanel)e.nextElement()).addParamterPanelSourceChangedListener(this);
        }
    }

    public void parameterPanelSourceChanged(ParameterPanel sourcePanel, Block newSource) {
        this.removeAsParameterPanelSourceChangedListener(this.fParameterPanels);
        Vector parameter = this.getParameters(newSource, this.fLogoDrawing.getCommentManager());
        this.fTabbedPane.removeAll();
        this.fParameterPanels = this.insertPanels(parameter);
        this.addAsParameterPanelSourceChangedListener(this.fParameterPanels);
    }

    private void removeAsParameterPanelSourceChangedListener(Vector parameterPanels) {
        Enumeration e = parameterPanels.elements();
        while (e.hasMoreElements()) {
            ((ParameterPanel)e.nextElement()).removeParameterPanelSourceChangedListener(this);
        }
    }

    public void storeFieldContents() {
        boolean modified = false;
        for (int i = this.fTabbedPane.getTabCount(); i > 0; --i) {
            ParameterPanel parameterPanel = (ParameterPanel)this.fTabbedPane.getComponentAt(i - 1);
            if (!parameterPanel.checkChanged()) continue;
            parameterPanel.storeFieldContents();
            parameterPanel.getParameterReference().fireParameterSetEvent();
            modified = true;
        }
        if (modified) {
            this.fLogoDrawing.setModified(true);
        }
    }

    public void loadFieldContents() {
        Enumeration panels = this.fParameterPanels.elements();
        while (panels.hasMoreElements()) {
            ParameterPanel panel = (ParameterPanel)panels.nextElement();
            try {
                panel.loadFieldContents();
            }
            catch (ProgramException e) {
                e.printStackTrace();
            }
        }
    }

    public void setLabels() {
        Enumeration panels = this.fParameterPanels.elements();
        while (panels.hasMoreElements()) {
            ParameterPanel panel = (ParameterPanel)panels.nextElement();
            panel.setLabels();
        }
    }
}

